/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.CachedColumnRenderSource;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.util.KeyedLockContainer;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadTree;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.WillNotClose;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class LodQuadTree
extends QuadTree<LodRenderSection>
implements IDebugRenderable,
AutoCloseable {
    public static final byte TREE_LOWEST_DETAIL_LEVEL = 6;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final ThreadPoolExecutor FULL_DATA_RETRIEVAL_QUEUE_THREAD = ThreadUtil.makeSingleThreadPool("QuadTree Full Data Retrieval Queue Populator");
    private static final int WORLD_GEN_QUEUE_UPDATE_DELAY_IN_MS = 1000;
    public final int blockRenderDistanceDiameter;
    @WillNotClose
    private final FullDataSourceProviderV2 fullDataSourceProvider;
    private final ConcurrentLinkedQueue<Long> sectionsToReload = new ConcurrentLinkedQueue();
    private final IDhClientLevel level;
    private final ReentrantLock treeReadWriteLock = new ReentrantLock();
    private final AtomicBoolean fullDataRetrievalQueueRunning = new AtomicBoolean(false);
    private ArrayList<LodRenderSection> debugRenderSections = new ArrayList();
    private ArrayList<LodRenderSection> altDebugRenderSections = new ArrayList();
    private final ReentrantLock debugRenderSectionLock = new ReentrantLock();
    protected final KeyedLockContainer<Long> renderLoadLockContainer = new KeyedLockContainer();
    private final Cache<Long, CachedColumnRenderSource> cachedRenderSourceByPos = CacheBuilder.newBuilder().maximumSize((long)(Runtime.getRuntime().availableProcessors() + 1) * 5L).build();
    public final AtomicInteger uploadTaskCountRef = new AtomicInteger(0);
    @Nullable
    public final BeaconRenderHandler beaconRenderHandler;
    private byte maxRenderDetailLevel;
    private byte minRenderDetailLevel;
    private double detailDropOffDistanceUnit;
    private double detailDropOffLogBase;

    public LodQuadTree(IDhClientLevel level, int viewDiameterInBlocks, int initialPlayerBlockX, int initialPlayerBlockZ, FullDataSourceProviderV2 fullDataSourceProvider) {
        super(viewDiameterInBlocks, new DhBlockPos2D(initialPlayerBlockX, initialPlayerBlockZ), (byte)6);
        DebugRenderer.register(this, Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus);
        this.level = level;
        this.fullDataSourceProvider = fullDataSourceProvider;
        this.blockRenderDistanceDiameter = viewDiameterInBlocks;
        GenericObjectRenderer genericObjectRenderer = this.level.getGenericRenderer();
        this.beaconRenderHandler = genericObjectRenderer != null ? new BeaconRenderHandler(genericObjectRenderer) : null;
    }

    public void tick(DhBlockPos2D playerPos) {
        if (this.level == null) {
            return;
        }
        this.updateDetailLevelVariables();
        if (this.treeReadWriteLock.tryLock()) {
            try {
                this.setCenterBlockPos(playerPos, LodRenderSection::close);
                this.updateAllRenderSections(playerPos);
            }
            catch (Exception e) {
                LOGGER.error("Quad Tree tick exception for level: [" + this.level.getLevelWrapper().getDhIdentifier() + "], error: [" + e.getMessage() + "].", (Throwable)e);
            }
            finally {
                this.treeReadWriteLock.unlock();
            }
        }
    }

    private void updateAllRenderSections(DhBlockPos2D playerPos) {
        if (Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus.get().booleanValue()) {
            try {
                this.debugRenderSectionLock.lock();
                this.debugRenderSections.clear();
                ArrayList<LodRenderSection> temp = this.debugRenderSections;
                this.debugRenderSections = this.altDebugRenderSections;
                this.altDebugRenderSections = temp;
            }
            finally {
                this.debugRenderSectionLock.unlock();
            }
        }
        HashSet<LodRenderSection> nodesNeedingRetrieval = new HashSet<LodRenderSection>();
        HashSet<LodRenderSection> nodesNeedingLoading = new HashSet<LodRenderSection>();
        LongIterator rootPosIterator = this.rootNodePosIterator();
        while (rootPosIterator.hasNext()) {
            long rootPos = rootPosIterator.nextLong();
            if (this.getNode(rootPos) == null) {
                this.setValue(rootPos, new LodRenderSection(rootPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef, this.cachedRenderSourceByPos, this.renderLoadLockContainer));
            }
            QuadNode<LodRenderSection> rootNode = this.getNode(rootPos);
            this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, rootNode, rootNode.sectionPos, false, nodesNeedingRetrieval, nodesNeedingLoading);
        }
        if (!this.fullDataRetrievalQueueRunning.get()) {
            this.fullDataRetrievalQueueRunning.set(true);
            FULL_DATA_RETRIEVAL_QUEUE_THREAD.execute(() -> this.queueFullDataRetrievalTasks(playerPos, nodesNeedingRetrieval));
        }
        this.reloadQueuedSections();
        this.loadQueuedSections(playerPos, nodesNeedingLoading);
    }

    private boolean recursivelyUpdateRenderSectionNode(DhBlockPos2D playerPos, QuadNode<LodRenderSection> rootNode, QuadNode<LodRenderSection> quadNode, long sectionPos, boolean parentSectionIsRendering, HashSet<LodRenderSection> nodesNeedingRetrieval, HashSet<LodRenderSection> nodesNeedingLoading) {
        if (quadNode == null && this.isSectionPosInBounds(sectionPos)) {
            rootNode.setValue(sectionPos, new LodRenderSection(sectionPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef, this.cachedRenderSourceByPos, this.renderLoadLockContainer));
            quadNode = rootNode.getNode(sectionPos);
        }
        if (quadNode == null) {
            return false;
        }
        LodRenderSection renderSection = (LodRenderSection)quadNode.value;
        if (renderSection == null) {
            renderSection = new LodRenderSection(sectionPos, this, this.level, this.fullDataSourceProvider, this.uploadTaskCountRef, this.cachedRenderSourceByPos, this.renderLoadLockContainer);
            quadNode.setValue(sectionPos, renderSection);
        }
        byte expectedDetailLevel = this.calculateExpectedDetailLevel(playerPos, sectionPos);
        expectedDetailLevel = (byte)Math.min(expectedDetailLevel, this.minRenderDetailLevel);
        expectedDetailLevel = (byte)(expectedDetailLevel + 6);
        if (DhSectionPos.getDetailLevel(sectionPos) > expectedDetailLevel) {
            QuadNode<LodRenderSection> childNode;
            int i;
            boolean thisPosIsRendering = renderSection.getRenderingEnabled();
            boolean allChildrenSectionsAreLoaded = true;
            for (i = 0; i < 4; ++i) {
                childNode = quadNode.getChildByIndex(i);
                boolean childSectionLoaded = this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, DhSectionPos.getChildByIndex(sectionPos, i), thisPosIsRendering || parentSectionIsRendering, nodesNeedingRetrieval, nodesNeedingLoading);
                allChildrenSectionsAreLoaded = childSectionLoaded && allChildrenSectionsAreLoaded;
            }
            if (!allChildrenSectionsAreLoaded) {
                return thisPosIsRendering;
            }
            if (renderSection.getRenderingEnabled()) {
                renderSection.onRenderingDisabled();
                long parentPos = renderSection.pos;
                while (DhSectionPos.getDetailLevel(parentPos) <= this.treeMinDetailLevel) {
                    LodRenderSection parentRenderSection;
                    QuadNode parentNode = this.getNode(parentPos);
                    if (parentNode != null && (parentRenderSection = (LodRenderSection)parentNode.value) != null) {
                        parentRenderSection.setRenderingEnabled(false);
                        ColumnRenderBuffer buffer = parentRenderSection.renderBuffer;
                        if (buffer != null) {
                            buffer.close();
                            parentRenderSection.renderBuffer = null;
                        }
                    }
                    parentPos = DhSectionPos.getParentPos(parentPos);
                }
                if (Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionToggling.get().booleanValue()) {
                    DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(renderSection.pos, 128.0f, 156.0f, 0.09f, Color.WHITE), 0.2, 32.0f));
                }
            }
            for (i = 0; i < 4; ++i) {
                childNode = quadNode.getChildByIndex(i);
                this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, DhSectionPos.getChildByIndex(sectionPos, i), parentSectionIsRendering, nodesNeedingRetrieval, nodesNeedingLoading);
            }
            renderSection.setRenderingEnabled(false);
            return true;
        }
        if (DhSectionPos.getDetailLevel(sectionPos) == expectedDetailLevel || DhSectionPos.getDetailLevel(sectionPos) == expectedDetailLevel - 1) {
            if (!renderSection.gpuUploadInProgress() && renderSection.renderBuffer == null) {
                nodesNeedingLoading.add(renderSection);
            }
            if (!renderSection.isFullyGenerated()) {
                nodesNeedingRetrieval.add(renderSection);
            }
            if (Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus.get().booleanValue()) {
                this.debugRenderSections.add(renderSection);
            }
            if (!parentSectionIsRendering && renderSection.canRender() && !renderSection.getRenderingEnabled()) {
                renderSection.setRenderingEnabled(true);
                quadNode.deleteAllChildren(childRenderSection -> {
                    if (childRenderSection != null) {
                        if (childRenderSection.getRenderingEnabled() && Config.Client.Advanced.Debugging.DebugWireframe.showRenderSectionToggling.get().booleanValue()) {
                            DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(childRenderSection.pos, 128.0f, 156.0f, 0.09f, Color.MAGENTA), 0.2, 32.0f));
                        }
                        childRenderSection.setRenderingEnabled(false);
                        childRenderSection.onRenderingDisabled();
                        childRenderSection.close();
                    }
                });
                renderSection.onRenderingEnabled();
            }
            return renderSection.canRender();
        }
        throw new IllegalStateException("LodQuadTree shouldn't be updating renderSections below the expected detail level: [" + expectedDetailLevel + "].");
    }

    private void reloadQueuedSections() {
        Long pos;
        HashSet<Long> positionsToRequeue = new HashSet<Long>();
        while ((pos = this.sectionsToReload.poll()) != null) {
            if (positionsToRequeue.contains(pos)) continue;
            try {
                LodRenderSection renderSection = (LodRenderSection)this.getValue(pos);
                if (renderSection == null) continue;
                renderSection.updateFullDataSourceExists();
                if (!renderSection.canRender() || !renderSection.gpuUploadInProgress() && renderSection.uploadRenderDataToGpuAsync()) continue;
                positionsToRequeue.add(pos);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        this.sectionsToReload.addAll(positionsToRequeue);
    }

    private void loadQueuedSections(DhBlockPos2D playerPos, HashSet<LodRenderSection> nodesNeedingLoading) {
        ArrayList<LodRenderSection> loadSectionList = new ArrayList<LodRenderSection>(nodesNeedingLoading);
        loadSectionList.sort((a, b) -> {
            int aDist = DhSectionPos.getManhattanBlockDistance(a.pos, playerPos);
            int bDist = DhSectionPos.getManhattanBlockDistance(b.pos, playerPos);
            return Integer.compare(aDist, bDist);
        });
        for (int i = 0; i < loadSectionList.size(); ++i) {
            LodRenderSection renderSection = loadSectionList.get(i);
            if (renderSection.gpuUploadInProgress() || renderSection.renderBuffer != null) continue;
            renderSection.uploadRenderDataToGpuAsync();
        }
    }

    public byte calculateExpectedDetailLevel(DhBlockPos2D playerPos, long sectionPos) {
        return this.getDetailLevelFromDistance(playerPos.dist(DhSectionPos.getCenterBlockPosX(sectionPos), DhSectionPos.getCenterBlockPosZ(sectionPos)));
    }

    private byte getDetailLevelFromDistance(double distance) {
        double maxDetailDistance = this.getDrawDistanceFromDetail(126);
        if (distance > maxDetailDistance) {
            return 126;
        }
        int detailLevel = (int)(Math.log(distance / this.detailDropOffDistanceUnit) / this.detailDropOffLogBase);
        return (byte)MathUtil.clamp(this.maxRenderDetailLevel, detailLevel, 126);
    }

    private double getDrawDistanceFromDetail(int detail) {
        if (detail <= this.maxRenderDetailLevel) {
            return 0.0;
        }
        if (detail >= 127) {
            return this.blockRenderDistanceDiameter * 2;
        }
        double base = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase;
        return Math.pow(base, detail) * this.detailDropOffDistanceUnit;
    }

    private void updateDetailLevelVariables() {
        this.detailDropOffDistanceUnit = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().distanceUnitInBlocks * 16;
        this.detailDropOffLogBase = Math.log(Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase);
        this.maxRenderDetailLevel = Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution.get().detailLevel;
        byte minSectionDetailLevel = this.getDetailLevelFromDistance(this.blockRenderDistanceDiameter);
        minSectionDetailLevel = (byte)(minSectionDetailLevel - 1);
        minSectionDetailLevel = (byte)Math.min(minSectionDetailLevel, this.treeMinDetailLevel);
        this.minRenderDetailLevel = (byte)Math.max(minSectionDetailLevel, this.maxRenderDetailLevel);
    }

    public void clearRenderDataCache() {
        if (this.treeReadWriteLock.tryLock()) {
            try {
                LOGGER.info("Disposing render data...");
                Iterator nodeIterator = this.nodeIterator();
                while (nodeIterator.hasNext()) {
                    QuadNode quadNode = nodeIterator.next();
                    if (quadNode.value == null) continue;
                    ((LodRenderSection)quadNode.value).close();
                    quadNode.value = null;
                }
                LOGGER.info("Render data cleared, please wait a moment for everything to reload...");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error when clearing LodQuadTree render cache: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.treeReadWriteLock.unlock();
            }
        }
    }

    public void reloadPos(long pos) {
        long adjacentPos;
        this.clearRenderCacheForPos(pos);
        for (EDhDirection direction : EDhDirection.ADJ_DIRECTIONS) {
            adjacentPos = DhSectionPos.getAdjacentPos(pos, direction);
            this.clearRenderCacheForPos(adjacentPos);
        }
        this.sectionsToReload.add(pos);
        for (EDhDirection direction : EDhDirection.ADJ_DIRECTIONS) {
            adjacentPos = DhSectionPos.getAdjacentPos(pos, direction);
            this.sectionsToReload.add(adjacentPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRenderCacheForPos(long pos) {
        ReentrantLock lock = this.renderLoadLockContainer.getLockForPos(pos);
        try {
            lock.lock();
            this.cachedRenderSourceByPos.invalidate((Object)pos);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueFullDataRetrievalTasks(DhBlockPos2D playerPos, HashSet<LodRenderSection> nodesNeedingRetrieval) {
        try {
            Thread.sleep(1000L);
            ArrayList<LodRenderSection> nodeList = new ArrayList<LodRenderSection>(nodesNeedingRetrieval);
            nodeList.sort((a, b) -> {
                int aDist = DhSectionPos.getManhattanBlockDistance(a.pos, playerPos);
                int bDist = DhSectionPos.getManhattanBlockDistance(b.pos, playerPos);
                return Integer.compare(aDist, bDist);
            });
            for (int i = 0; i < nodeList.size(); ++i) {
                LodRenderSection renderSection = nodeList.get(i);
                if (!this.fullDataSourceProvider.canQueueRetrieval()) break;
                renderSection.tryQueuingMissingLodRetrieval();
            }
            int totalWorldGenChunkCount = 0;
            int totalWorldGenTaskCount = 0;
            for (int i = 0; i < nodeList.size(); ++i) {
                LodRenderSection renderSection = nodeList.get(i);
                if (!renderSection.missingPositionsCalculated()) {
                    int sectionWidthInChunks = DhSectionPos.getChunkWidth(renderSection.pos);
                    totalWorldGenChunkCount += sectionWidthInChunks * sectionWidthInChunks;
                    totalWorldGenTaskCount += renderSection.ungeneratedPositionCount();
                    continue;
                }
                totalWorldGenChunkCount += renderSection.ungeneratedChunkCount();
                ++totalWorldGenTaskCount;
            }
            this.fullDataSourceProvider.setEstimatedRemainingRetrievalChunkCount(totalWorldGenChunkCount);
            this.fullDataSourceProvider.setTotalRetrievalPositionCount(totalWorldGenTaskCount);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.fullDataRetrievalQueueRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugRender(DebugRenderer debugRenderer) {
        try {
            this.debugRenderSectionLock.lock();
            for (int i = 0; i < this.debugRenderSections.size(); ++i) {
                LodRenderSection renderSection = this.debugRenderSections.get(i);
                Color color = Color.BLACK;
                if (renderSection.gpuUploadInProgress()) {
                    color = Color.ORANGE;
                } else if (renderSection.renderBuffer == null) {
                    color = Color.PINK;
                } else if (renderSection.renderBuffer.hasNonNullVbos()) {
                    color = renderSection.renderBuffer.vboBufferCount() != 0 ? Color.GREEN : Color.RED;
                }
                debugRenderer.renderBox(new DebugRenderer.Box(renderSection.pos, 400.0f, 400.0f, (Object)Objects.hashCode(this), 0.05f, color));
            }
        }
        finally {
            this.debugRenderSectionLock.unlock();
        }
    }

    @Override
    public void close() {
        LOGGER.info("Shutting down LodQuadTree...");
        DebugRenderer.unregister(this, Config.Client.Advanced.Debugging.DebugWireframe.showQuadTreeRenderStatus);
        ThreadPoolExecutor mainCleanupExecutor = ThreadPoolUtil.getCleanupExecutor();
        mainCleanupExecutor.execute(() -> {
            this.treeReadWriteLock.lock();
            try {
                Iterator nodeIterator = this.nodeIterator();
                ArrayList<CompletableFuture<Void>> renderDataBuildFutures = new ArrayList<CompletableFuture<Void>>();
                while (nodeIterator.hasNext()) {
                    QuadNode quadNode = nodeIterator.next();
                    LodRenderSection renderSection = (LodRenderSection)quadNode.value;
                    if (renderSection == null) continue;
                    CompletableFuture<Void> future = renderSection.getRenderDataBuildFuture();
                    if (future != null) {
                        renderDataBuildFutures.add(future);
                    }
                    renderSection.close();
                    quadNode.value = null;
                }
                LOGGER.info("waiting for [" + renderDataBuildFutures.size() + "] futures before closing render cache...");
                CompletableFuture.allOf(renderDataBuildFutures.toArray(new CompletableFuture[0])).handle((voidObj, throwable) -> {
                    new Thread(() -> {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOGGER.debug("closing render cache");
                        this.cachedRenderSourceByPos.invalidateAll();
                    }).start();
                    return null;
                });
            }
            finally {
                this.treeReadWriteLock.unlock();
            }
        });
        LOGGER.info("Finished shutting down LodQuadTree");
    }
}

